// config: norepeat

#include "GetObjects.js"
#include "GetLine.js"

function DoTwist()
{
	var objectpicker = moi.ui.createObjectPicker();
	//objectpicker.allowEditPoints();

	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectObjectsPrompt' );
	moi.ui.hideUI( 'done' );
	moi.ui.showUI( 'FirstLinePrompt' );
	moi.ui.endUIUpdate();


	var axispoints = new Array();

	if ( !GetLine( axispoints ) )
		return;
	
	var axislinefactory = moi.command.createFactory( 'line' );
	axislinefactory.setInput( 0, axispoints[0] );
	axislinefactory.setInput( 1, axispoints[1] );
	axislinefactory.update();
			
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SecondLinePrompt' );
	moi.ui.showUI( 'TwistAnglePrompt' );
	moi.ui.showUI( 'TwistOptions' );
	moi.ui.showUI( 'done' );
	moi.ui.endUIUpdate();

	var factory = moi.command.createFactory( 'twist' );
	factory.setInput( 0, objects );
	factory.setInput( 1, axispoints[0] );
	factory.setInput( 2, axispoints[1] );
	
	factory.disableUpdate( true );
	moi.ui.bindUIToInput( 'angleinput', 'value', factory.getInput(3) );
	moi.ui.bindUIToInput( 'limittoaxis', 'value', factory.getInput(4) );
	moi.ui.bindUIToInput( 'easein', 'value', factory.getInput(5) );
	moi.ui.bindUIToInput( 'easeout', 'value', factory.getInput(6) );
	factory.disableUpdate( false );
	
    try {
        var angle = moi.ui.commandUI.angleinput.value;

		if ( angle != undefined && angle != 0.0 )
			factory.update();
	}
	catch(e) {
	}


	var dlg = moi.ui.commandDialog;
	
	while ( 1 )
	{
		if ( !dlg.waitForEvent() )
			return false; // Canceled
			
		if ( dlg.event == 'done' )
			break;
	}
	
	factory.commit();
}

DoTwist();
